<?php
/**
 * Admin settings page
 *
 * @package FreshNews_AI_Content_Hub
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Check user capabilities
if ( ! current_user_can( 'manage_options' ) ) {
	return;
}

// Handle settings save
if ( isset( $_POST['submit'] ) && check_admin_referer( 'freshnews_ai_newsroom_options-options' ) ) {
	// Settings are saved via Settings API
	?>
	<div class="notice notice-success is-dismissible">
		<p><strong><?php esc_html_e( 'Settings saved.', 'freshnews-ai-content-hub' ); ?></strong></p>
	</div>
	<?php
}

// Tab structure: tab_id => array of section IDs
$tabs = array(
	'general' => array(
		'label'   => __( 'General', 'freshnews-ai-content-hub' ),
		'sections' => array( 'freshnews_ai_newsroom_general', 'freshnews_ai_newsroom_seo', 'freshnews_ai_newsroom_footer' ),
	),
	'widget'  => array(
		'label'   => __( 'Widget', 'freshnews-ai-content-hub' ),
		'sections' => array( 'freshnews_ai_newsroom_widget' ),
	),
	'pages'   => array(
		'label'   => __( 'Pages', 'freshnews-ai-content-hub' ),
		'sections' => array( 'freshnews_ai_newsroom_page' ),
	),
	'advanced' => array(
		'label'   => __( 'Advanced', 'freshnews-ai-content-hub' ),
		'sections' => array( 'freshnews_ai_newsroom_advanced' ),
	),
);

$page_slug = 'freshnews_ai_newsroom';
global $wp_settings_sections, $wp_settings_fields;
$sections = isset( $wp_settings_sections[ $page_slug ] ) ? $wp_settings_sections[ $page_slug ] : array();
$fields   = isset( $wp_settings_fields[ $page_slug ] ) ? $wp_settings_fields[ $page_slug ] : array();
?>

<div class="wrap freshnews-ai-settings">
	<h1><?php echo esc_html( get_admin_page_title() ); ?></h1>

	<nav class="nav-tab-wrapper freshnews-ai-tabs" aria-label="<?php esc_attr_e( 'Settings tabs', 'freshnews-ai-content-hub' ); ?>">
		<?php
		$first = true;
		foreach ( $tabs as $tab_id => $tab ) {
			$active = $first ? ' nav-tab-active' : '';
			?>
			<a href="#<?php echo esc_attr( $tab_id ); ?>" class="nav-tab<?php echo esc_attr( $active ); ?>" data-tab="<?php echo esc_attr( $tab_id ); ?>"><?php echo esc_html( $tab['label'] ); ?></a>
			<?php
			$first = false;
		}
		?>
	</nav>

	<form action="options.php" method="post">
		<?php settings_fields( 'freshnews_ai_newsroom_options' ); ?>

		<?php
		foreach ( $tabs as $tab_id => $tab ) {
			$active_class = ( 'general' === $tab_id ) ? ' freshnews-ai-tab-panel-active' : '';
			?>
			<div id="freshnews-tab-<?php echo esc_attr( $tab_id ); ?>" class="freshnews-ai-tab-panel<?php echo esc_attr( $active_class ); ?>" role="tabpanel" aria-labelledby="tab-<?php echo esc_attr( $tab_id ); ?>">
				<?php
				foreach ( $tab['sections'] as $section_id ) {
					if ( ! isset( $sections[ $section_id ] ) ) {
						continue;
					}
					$section = $sections[ $section_id ];
					?>
					<h2 class="title"><?php echo esc_html( $section['title'] ); ?></h2>
					<?php
					if ( ! empty( $section['callback'] ) && is_callable( $section['callback'] ) ) {
						call_user_func( $section['callback'], $section );
					}
					?>
					<table class="form-table" role="presentation">
						<?php
						if ( isset( $fields[ $section_id ] ) ) {
							foreach ( $fields[ $section_id ] as $field ) {
								?>
								<tr>
									<?php if ( ! empty( $field['args']['label_for'] ) ) { ?>
										<th scope="row"><label for="<?php echo esc_attr( $field['args']['label_for'] ); ?>"><?php echo wp_kses( $field['title'], array( 'span' => array( 'class' => true ) ) ); ?></label></th>
									<?php } else { ?>
										<th scope="row"><?php echo wp_kses( $field['title'], array( 'span' => array( 'class' => true ) ) ); ?></th>
									<?php } ?>
									<td>
										<?php
										if ( ! empty( $field['callback'] ) && is_callable( $field['callback'] ) ) {
											call_user_func( $field['callback'], $field['args'] );
										}
										?>
									</td>
								</tr>
								<?php
							}
						}
						?>
					</table>
					<?php
				}
				?>
			</div>
			<?php
		}
		?>

		<p class="submit">
			<?php submit_button( __( 'Save Settings', 'freshnews-ai-content-hub' ), 'primary', 'submit', false ); ?>
		</p>
	</form>

	<style>
		.freshnews-ai-settings .form-table th {
			width: 200px;
		}
		.freshnews-ai-settings .required {
			color: #d63638;
		}
		.freshnews-ai-settings .optional {
			color: #646970;
			font-weight: normal;
		}
		.freshnews-ai-settings .recommended {
			color: #007017;
			font-weight: normal;
		}
		.freshnews-ai-settings input[disabled] {
			opacity: 0.6;
			cursor: not-allowed;
		}
		.freshnews-ai-tabs {
			margin: 20px 0 0 0;
		}
		.freshnews-ai-tab-panel {
			display: none;
			padding-top: 20px;
		}
		.freshnews-ai-tab-panel.freshnews-ai-tab-panel-active {
			display: block;
		}
		.freshnews-ai-tab-panel .title {
			margin-top: 24px;
			margin-bottom: 12px;
		}
		.freshnews-ai-tab-panel .title:first-child {
			margin-top: 0;
		}
	</style>
	<script>
		jQuery(document).ready(function($) {
			// Tab switching
			$('.freshnews-ai-tabs .nav-tab').on('click', function(e) {
				e.preventDefault();
				var tab = $(this).data('tab');
				$('.freshnews-ai-tabs .nav-tab').removeClass('nav-tab-active');
				$(this).addClass('nav-tab-active');
				$('.freshnews-ai-tab-panel').removeClass('freshnews-ai-tab-panel-active');
				$('#freshnews-tab-' + tab).addClass('freshnews-ai-tab-panel-active');
				window.location.hash = tab;
			});

			// Restore tab from URL hash
			var hash = window.location.hash.replace('#', '');
			if (hash && $('.freshnews-ai-tabs .nav-tab[data-tab="' + hash + '"]').length) {
				$('.freshnews-ai-tabs .nav-tab').removeClass('nav-tab-active');
				$('.freshnews-ai-tabs .nav-tab[data-tab="' + hash + '"]').addClass('nav-tab-active');
				$('.freshnews-ai-tab-panel').removeClass('freshnews-ai-tab-panel-active');
				$('#freshnews-tab-' + hash).addClass('freshnews-ai-tab-panel-active');
			}

			// Enable/disable Insights page fields based on checkbox
			function toggleInsightsFields() {
				var enabled = $('#enable_insights_page').is(':checked');
				$('#insights_page_slug, #insights_page_title').prop('disabled', !enabled);
			}
			toggleInsightsFields();
			$('#enable_insights_page').on('change', toggleInsightsFields);

			// Enable/disable footer lang field when mode is fixed
			function toggleFooterLangField() {
				var mode = $('#footer_pulse_lang_mode').val();
				$('#footer_pulse_lang').prop('disabled', mode !== 'fixed');
			}
			toggleFooterLangField();
			$('#footer_pulse_lang_mode').on('change', toggleFooterLangField);
		});
	</script>
</div>
