/**
 * FreshNews AI Content Hub - Health checks admin UI
 */
(function($) {
	'use strict';

	var labels = {
		dns: 'DNS / CNAME',
		hub: 'Hub reachability',
		sitemap: 'Sitemap',
		latest: 'Latest page',
		footer_script: 'Footer embed script'
	};

	var order = ['dns', 'hub', 'sitemap', 'latest', 'footer_script'];

	function renderResults(data) {
		var html = '';
		order.forEach(function(k) {
			var item = data[k];
			if (!item) return;
			var c = 'status-' + item.status;
			var msg = (item.message || '').replace(/</g, '&lt;').replace(/>/g, '&gt;');
			var label = labels[k] || k;
			html += '<div class="freshnews-health-row"><span class="freshnews-health-label">' + label + '</span> <span class="freshnews-health-pill ' + c + '">' + item.status + '</span> <span class="freshnews-health-msg">' + msg + '</span></div>';
		});
		$('#freshnews-health-checks-results .freshnews-health-rows').html(html || '<p>No results</p>');
	}

	$(function() {
		var $btn = $('#freshnews-run-health-tests');
		if (!$btn.length) return;

		var $spinner = $('#freshnews-health-tests-spinner');

		$btn.on('click', function() {
			var $b = $(this);
			$b.prop('disabled', true);
			$spinner.addClass('is-active');

			$.post(
				window.ajaxurl || (window.freshnewsHealthChecks && freshnewsHealthChecks.ajaxurl),
				{
					action: 'freshnews_run_health_checks',
					_wpnonce: $('#freshnews_health_nonce').val()
				}
			)
			.done(function(r) {
				if (r.success && r.data) {
					renderResults(r.data);
				}
			})
			.always(function() {
				$b.prop('disabled', false);
				$spinner.removeClass('is-active');
			});
		});
	});
})(jQuery);
