# Local Installation Guide

## Quick Installation Steps

### Option 1: Copy Plugin Folder (Recommended)

1. **Locate your local WordPress installation**
   - Typically located at: `~/Sites/your-site/wp-content/plugins/` (MAMP/XAMPP)
   - Or: `/Applications/MAMP/htdocs/your-site/wp-content/plugins/`
   - Or wherever your local WordPress is installed

2. **Copy the plugin folder**
   ```bash
   # From the project root, copy the plugin folder to your WordPress plugins directory
   cp -r wp-content/plugins/freshnews-ai-content-hub /path/to/your/wordpress/wp-content/plugins/
   ```

3. **Activate the plugin**
   - Go to your WordPress admin: `http://localhost/your-site/wp-admin`
   - Navigate to: **Plugins** → **Installed Plugins**
   - Find "FreshNews AI Content Hub" and click **Activate**

4. **Configure the plugin**
   - Go to: **Settings** → **FreshNews AI Content Hub**
   - Enter your Signals URL (e.g., `http://localhost:4010` for local development)
   - Enter your Embed Script URL (e.g., `http://localhost:4010/embed/insights.js`)
   - Optionally enter Embed CSS URL (e.g., `http://localhost:4010/embed/insights.css`)
   - Configure other settings as needed
   - Click **Save Settings**

### Option 2: Create Symbolic Link (For Development)

If you're actively developing the plugin and want changes to reflect immediately:

```bash
# Create a symlink from your WordPress plugins directory to this plugin folder
ln -s /path/to/content-hub/wp-content/plugins/freshnews-ai-content-hub /path/to/your/wordpress/wp-content/plugins/freshnews-ai-content-hub
```

**Note:** Replace paths with your actual WordPress and project paths.

### Option 3: Use WordPress CLI (wp-cli)

If you have wp-cli installed:

```bash
cd /path/to/your/wordpress
wp plugin install /path/to/content-hub/wp-content/plugins/freshnews-ai-content-hub --activate
```

## Local Development Configuration

For local development with the FreshNews.ai frontend running on `localhost:4010`:

**Settings to use:**
- **Signals URL**: `http://localhost:4010`
- **Embed Script URL**: `http://localhost:4010/embed/insights.js`
- **Embed CSS URL**: `http://localhost:4010/embed/insights.css`
- **Widget Mode**: `signals-list` or `insights-list`
- **Article Kind**: `daily` or `insight`
- **Language**: `en`

**Note:** For localhost, you may need to provide a tenant slug. Check the embed API documentation for details.

## Testing

After installation:

1. The plugin will auto-create a page at `/signals` (or your configured slug)
2. Visit that page to see the embedded content hub
3. You can also use the shortcode `[freshnews_content_hub]` in any post or page (or `[freshnews_newsroom]` for backward compatibility)

## Troubleshooting

- **Plugin not showing**: Make sure the folder is in `wp-content/plugins/` and has the correct name
- **Scripts not loading**: Check that your Signals URL and Embed Script URL are correct
- **Widget not displaying**: Check browser console for errors and verify your local FreshNews.ai frontend is running
